// hitop - an HTML preprocessor
// Copyright 1997-2001 David Marshall & Darren Edmundson

#ifndef __dtutilsh__
  #include "dtutils.h"
#endif
#ifndef __hitopcoreh__
  #include "hitopcore.h"
#endif
#ifndef __htmlh__
  #include "html.h"
#endif
#ifndef __htmlstreamh__
  #include "htmlstream.h"
#endif
#ifndef __tokenmaph__
  #include "tokenmap.h"
#endif
#include <fstream>
#include <sys/stat.h>
#include <string>

int G_CALLS=0;

void doError(const string& mess) {
  cerr << mess << endl;
  exit(0);
}

void doWarn(const string& mess) {
  cerr << mess << endl;
}

void doDebug(const string& mess) {
  cerr << mess << endl;
}

int main(int argn,char* argc[]){
  TokenMap::Init();
  const string About("hitop "+g_version+" "+g_years+" David Marshall & Darren Edmundson\n("+
    g_dateISO+") http://www.hitop.org/");
  const string Usage("Usage: hitop infile.hitop [outfile.html]");
  string inFile,outFile;
  if(!ParseArgs(argn,argc,inFile,outFile)){
    cerr<<About<<endl<<Usage<<endl;
    exit(0);
  }
  HTMLStream Main;
  Main.m_FName=inFile;
  ifstream InFile;
  InFile.open(inFile.c_str(),ios::in);
  if(InFile.is_open()){
    InFile>>Main;
    InFile.close();
  }else{
    cerr<<"Couldn't open input file '"<<inFile<<"'"<<endl;
    exit(1);
  }
  Main.SetVar("FILE",outFile,Vars::Global);
  string path=PathPart(outFile);
  Main.SetVar("RELPATH",replicate("../",count(path.begin(),path.end(),'/')),Vars::Global);
  Main.m_ThisPath=path;
  DoVars(&Main);
  Main.Process();
  if(!g_isXML&&g_isHTML) Main.CheckHTML();
  ofstream OutFile;
  OutFile.open(outFile.c_str(),ios::out,0664);
  if(OutFile.is_open()){
    OutFile<<Main;
    OutFile.close();
    chmod(outFile.c_str(),0644);
  }else{
    cerr<<"Couldn't open output file '"<<outFile<<"'"<<endl;
    exit(1);
  }
}
