#ifndef __dbmgrh__
#define __dbmgrh__

#ifndef __htmlstreamh__
  #include "htmlstream.h"
#endif
#ifndef __dbaseh__
  #include "dbase.h"
#endif
#include <map>
#include <string>

class DBManager {
public:
  typedef DBaseBase* (*ConnectFn)(const string&,HTMLStream&,HTMLStream::iterator,const ParamMap&);
  static HTMLStream::iterator Connect(HTMLStream& stream, HTMLStream::iterator cur,const ParamMap& paramMap,const string& tag);
  static HTMLStream::iterator Query(HTMLStream& stream, HTMLStream::iterator cur,const ParamMap& paramMap,const string& tag);
  static HTMLStream::iterator Disconnect(HTMLStream& stream, HTMLStream::iterator cur,const ParamMap& paramMap,const string& tag);
  static void RegisterDriver(string drivername,ConnectFn connector);
protected:
private:
  static map <string,ConnectFn> s_drivers;
  static map <string,DBaseBase*> s_connections;
};

#endif
